
// Initialize Vanta.js background
window.addEventListener('load', function() {
    // Check if VANTA is available
    if (typeof VANTA !== 'undefined') {
        const vantaEffect = VANTA.NET({
            el: "#vanta-bg",
            mouseControls: true,
            touchControls: true,
            gyroControls: false,
            minHeight: 200.00,
            minWidth: 200.00,
            scale: 1.00,
            scaleMobile: 1.00,
            color: 0x3a0ca3,
            backgroundColor: 0x111827,
            points: 12.00,
            maxDistance: 22.00,
            spacing: 18.00
        });
        
        // Handle resize
        window.addEventListener('resize', function() {
            vantaEffect.resize();
        });
    }
// Intersection Observer for section animations
    const sections = document.querySelectorAll('section');
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, { threshold: 0.1 });

    sections.forEach(section => {
        observer.observe(section);
    });

    // Feather icons replacement
    if (typeof feather !== 'undefined') {
        feather.replace();
    }
});
